import { Plugin } from "..";

export default class Variables extends Plugin {
  name = "variables";
  rewriteTriggers = ["html", "*"];
  renameTo = undefined;
  longLasting = false;

  varBuild!: () => Record<string, string>;
  variables!: Record<string, string>;

  constructor(varBuild: () => Record<string, string>) {
    super();
    this.varBuild = varBuild;
  }

  build() {
    this.variables = this.varBuild();
  }

  async rewriteFile(file: string, filePath: string): Promise<string> {
    let prevfile = file;
    for (const a of Object.entries(this.variables)) {
      prevfile = prevfile.replaceAll(a[0], a[1]);
    }
    return prevfile;
  }
}
